-- 案例展示表
CREATE TABLE IF NOT EXISTS cases (
  id VARCHAR(36) PRIMARY KEY DEFAULT gen_random_uuid(),
  title VARCHAR(200) NOT NULL,
  description TEXT,
  images TEXT NOT NULL,
  category VARCHAR(50),
  sort_order INTEGER DEFAULT 0,
  is_active BOOLEAN NOT NULL DEFAULT TRUE,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- 常见问题表
CREATE TABLE IF NOT EXISTS faqs (
  id VARCHAR(36) PRIMARY KEY DEFAULT gen_random_uuid(),
  question TEXT NOT NULL,
  answer TEXT NOT NULL,
  category VARCHAR(50),
  sort_order INTEGER DEFAULT 0,
  is_active BOOLEAN NOT NULL DEFAULT TRUE,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- 创建索引
CREATE INDEX IF NOT EXISTS cases_category_idx ON cases(category);
CREATE INDEX IF NOT EXISTS cases_sort_idx ON cases(sort_order);
CREATE INDEX IF NOT EXISTS cases_is_active_idx ON cases(is_active);
CREATE INDEX IF NOT EXISTS faqs_category_idx ON faqs(category);
CREATE INDEX IF NOT EXISTS faqs_sort_idx ON faqs(sort_order);
CREATE INDEX IF NOT EXISTS faqs_is_active_idx ON faqs(is_active);

-- 授权（根据Supabase配置调整）
GRANT ALL ON cases TO anon, authenticated, service_role;
GRANT ALL ON faqs TO anon, authenticated, service_role;

-- 插入默认常见问题数据
INSERT INTO faqs (question, answer, category, sort_order, is_active) VALUES
('从中国发货到俄罗斯需要多长时间？', '根据运输方式不同，时效也有所差异：

• 铁路运输：约15-25天
• 公路运输：约12-20天
• 空运：约3-7天

具体时效会根据起运城市、目的地城市、清关情况等因素有所调整，建议您提交询价单获取准确时效。', '运输问题', 1, true),
('货物清关需要哪些文件？', '中俄跨境运输通常需要以下清关文件：

• 贸易合同
• 商业发票
• 装箱单
• 原产地证明
• 运输合同
• 危险品需提供相关证明（如有）

我们的专业团队会协助您准备和审核所有必要文件。', '清关问题', 2, true),
('运费是如何计算的？', '运费计算主要考虑以下因素：

• 货物重量和体积（取较大值计费）
• 运输方式（铁路/公路/空运）
• 起运地和目的地
• 货物类型（普货/危险品/冷链等）
• 是否需要上门提货和送货上门

您可以提交询价单，我们会在24小时内为您提供详细报价。', '费用问题', 3, true),
('是否提供货物保险服务？', '是的，我们提供全程货物保险服务。

• 保险费率：货值的0.3%-0.5%
• 保险范围：全程运输（包括装卸、运输、清关）
• 理赔时效：确认损失后7个工作日内

建议贵重货物购买保险，保障您的利益。', '费用问题', 4, true),
('如何查询货物运输状态？', '我们提供多种查询方式：

1. 在线查询：登录用户中心，查看订单详情
2. 实时沟通：通过订单页面与我们在线沟通
3. 客服热线：拨打客服电话咨询

运输过程中，我们会实时更新货物状态，让您随时掌握货物动态。', '运输问题', 5, true),
('可以运输哪些类型的货物？', '我们承运的货物类型包括：

• 普通货物：服装、电子产品、日用品等
• 大件货物：机械设备、工程材料等
• 危险品：化工产品、易燃物品（需特殊申报）
• 冷链货物：食品、药品等温控货物

部分特殊货物需要额外审批，详情请咨询客服。', '运输问题', 6, true),
('俄罗斯哪些城市可以送达？', '我们覆盖俄罗斯主要城市和地区：

• 莫斯科、圣彼得堡
• 叶卡捷琳堡、新西伯利亚
• 喀山、下诺夫哥罗德
• 海参崴、哈巴罗夫斯克
• 其他城市可根据需求安排

基本上可以覆盖俄罗斯全境，偏远地区可能需要额外时间。', '运输问题', 7, true),
('货物损坏或丢失如何处理？', '如发生货物损坏或丢失，处理流程如下：

1. 第一时间联系客服登记
2. 提供货物照片和相关证明材料
3. 我们会立即启动调查程序
4. 如已投保，按保险流程理赔
5. 未投保货物按运输合同条款处理

我们会全力协助处理，确保您的权益。', '运输问题', 8, true),
('支持哪些支付方式？', '我们支持多种支付方式：

• 银行转账（人民币/美元/卢布）
• 支付宝、微信支付
• 信用证付款

一般流程：签约后支付30%定金，货物到达目的地后支付尾款。具体可协商。', '费用问题', 9, true),
('如何成为长期合作客户？', '我们欢迎长期合作，合作客户可享受：

• 优惠的运费价格
• 优先安排运输
• 专属客服对接
• 月结账期

如有意向，请联系我们的商务部门，我们会为您制定专属合作方案。', '合作问题', 10, true),
('清关一般需要多长时间？', '清关时间因货物类型和口岸不同有所差异：

• 普通货物：1-3个工作日
• 需商检货物：3-5个工作日
• 特殊货物：5-7个工作日

我们有专业的清关团队，熟悉各项流程，能够确保货物快速通关。', '清关问题', 11, true),
('出口俄罗斯需要注意什么？', '出口俄罗斯需要注意以下几点：

• 确保货物符合俄罗斯进口标准
• 准备完整的清关文件
• 了解俄罗斯进口关税政策
• 注意俄罗斯进口限制清单

我们的专业团队会全程指导，确保出口顺利。', '清关问题', 12, true),
('可以提供上门提货服务吗？', '是的，我们提供中国全境上门提货服务：

• 覆盖主要城市：北京、上海、广州、深圳等
• 提货费用根据距离和货物量计算
• 需提前预约，建议至少提前2天

提货服务与运输服务无缝衔接，一站式解决您的物流需求。', '运输问题', 13, true),
('货物包装有什么要求？', '为确保运输安全，货物包装需满足：

• 外包装坚固，能承受堆码和运输颠簸
• 易碎品需加装缓冲材料
• 防水防潮处理
• 每件货物粘贴清晰标签

如需包装服务，我们可以提供专业的包装解决方案。', '运输问题', 14, true),
('如何投诉或建议？', '我们重视每一位客户的反馈：

• 在线反馈：通过订单系统提交
• 客服热线：工作时间随时拨打
• 邮箱：support@xinqi-freight.com

我们承诺在24小时内回复您的投诉或建议，持续改进服务质量。', '合作问题', 15, true)
ON CONFLICT DO NOTHING;
