import { NextResponse } from 'next/server';
import { cookies } from 'next/headers';

// POST /api/auth/logout - 客户登出
export async function POST() {
  try {
    const cookieStore = await cookies();
    
    // 清除登录状态 cookie
    cookieStore.delete('customer_id');
    cookieStore.delete('customer_phone');
    
    return NextResponse.json({ 
      success: true, 
      message: '已退出登录'
    });
  } catch (error) {
    console.error('Error:', error);
    return NextResponse.json(
      { error: '服务器错误' },
      { status: 500 }
    );
  }
}
