'use client';

import { useEffect } from 'react';
import { LanguageProvider, useLanguage } from '@/i18n/LanguageContext';

function LanguageAttributeSetter() {
  const { locale } = useLanguage();
  
  useEffect(() => {
    // 更新 html 元素的 lang 属性
    if (typeof document !== 'undefined') {
      document.documentElement.lang = locale;
    }
  }, [locale]);
  
  return null;
}

export function Providers({ children }: { children: React.ReactNode }) {
  return (
    <LanguageProvider>
      <LanguageAttributeSetter />
      {children}
    </LanguageProvider>
  );
}
