// Русский перевод
import type { Translation } from './zh';

export const ru: Translation = {
  // Общее
  common: {
    logo: 'СИНЬЦИ ФРАЙТ',
    logoSub: 'XINQI FREIGHT',
    slogan: 'Профессиональный логистический оператор Китай-Россия',
    loading: 'Загрузка...',
    save: 'Сохранить',
    cancel: 'Отмена',
    confirm: 'Подтвердить',
    delete: 'Удалить',
    edit: 'Редактировать',
    add: 'Добавить',
    search: 'Поиск',
    submit: 'Отправить',
    back: 'Назад',
    preview: 'Предпросмотр',
    home: 'Главная',
    more: 'Подробнее',
    viewAll: 'Смотреть все',
    close: 'Закрыть',
  },

  // Навигация
  nav: {
    home: 'Главная',
    about: 'О нас',
    services: 'Услуги',
    cases: 'Проекты',
    faqs: 'FAQ',
    order: 'Онлайн запрос',
    contact: 'Контакты',
    userCenter: 'Личный кабинет',
    login: 'Войти',
    register: 'Регистрация',
    logout: 'Выход',
  },

  // Главная страница
  home: {
    heroTitle: 'Полная логистическая цепочка Китай-Россия',
    heroSubtitle: 'Упрощаем трансграничные перевозки',
    heroDesc: 'Профессиональный провайдер логистических решений Китай-Россия',
    inquiryNow: 'Запросить сейчас',
    learnMore: 'Подробнее',
    
    stats: {
      years: 'лет опыта',
      routes: 'маршрутов',
      cities: 'городов',
      clients: 'клиентов',
    },
    
    about: {
      title: 'О нас',
      subtitle: 'Профессиональный и надежный логистический оператор',
      desc1: 'Маньчжурия Синьци Международное Экспедирование — профессиональная компания в сфере трансграничной логистики Китай-Россия, штаб-квартира расположена в Маньчжурии — крупнейшем сухопутном порту Китая.',
      desc2: 'Мы предоставляем комплексные логистические решения: железнодорожные перевозки, автоперевозки, таможенное оформление, складирование и дистрибуция.',
      feature1Title: 'Профессиональная команда',
      feature1Desc: 'Опытная команда со специализацией на логистике Китай-Россия',
      feature2Title: 'Полное отслеживание',
      feature2Desc: 'Отслеживание грузов в реальном времени',
      feature3Title: 'Качественный сервис',
      feature3Desc: 'Поддержка 24/7, быстрое реагирование',
      feature4Title: 'Безопасность',
      feature4Desc: 'Полная система страхования грузов',
    },
    
    services: {
      title: 'Наши услуги',
      subtitle: 'Комплексные решения для трансграничной логистики',
      railway: 'Ж/Д перевозки',
      railwayDesc: 'Китайско-европейские поезда, транзит через Маньчжурию, стабильные сроки, выгодные тарифы',
      road: 'Автоперевозки',
      roadDesc: 'Гибкие решения «от двери до двери», идеально для срочных грузов',
      customs: 'Таможенное оформление',
      customsDesc: 'Профессиональная команда, знание торгового законодательства',
      warehouse: 'Складские услуги',
      warehouseDesc: 'Склады в Маньчжурии и России, хранение и дистрибуция',
    },
    
    order: {
      title: 'Онлайн запрос',
      subtitle: 'Заполните форму и получите оптимальное решение',
      contactName: 'Контактное лицо',
      contactNamePlaceholder: 'Введите имя',
      contactPhone: 'Телефон',
      contactPhonePlaceholder: 'Введите номер телефона',
      contactEmail: 'Email',
      contactEmailPlaceholder: 'Введите email (опционально)',
      originCity: 'Место отправления',
      originCityPlaceholder: 'Введите город в Китае',
      destinationCity: 'Место назначения',
      destinationCityPlaceholder: 'Введите город в России',
      customsCity: 'Место таможенного оформления',
      customsCityPlaceholder: 'Введите город оформления в России',
      notes: 'Примечания',
      notesPlaceholder: 'Опишите тип груза, вес, объем...',
      submit: 'Отправить запрос',
      submitting: 'Отправка...',
      submitSuccess: 'Запрос успешно отправлен!',
      submitSuccessDesc: 'Мы свяжемся с вами в течение 24 часов.',
    },
    
    contact: {
      title: 'Контакты',
      subtitle: 'Свяжитесь с нами для консультации',
      address: 'Адрес',
      addressValue: 'г. Маньчжурия, Внутренняя Монголия, Китай',
      phone: 'Телефон',
      email: 'Email',
      wechat: 'WeChat',
      workingHours: 'Часы работы',
      workingHoursValue: 'Пн-Сб 9:00-18:00',
    },
    
    footer: {
      copyright: '© 2025 Маньчжурия Синьци Международное Экспедирование',
      icp: 'ICP: XXXXXXXX',
    },
  },

  // Страница услуг
  services: {
    title: 'Услуги',
    subtitle: 'Комплексные решения для трансграничной логистики Китай-Россия',
    railway: 'Ж/Д перевозки',
    road: 'Автоперевозки',
    customs: 'Таможенное оформление',
    warehouse: 'Складские услуги',
    // Новые поля
    all: 'Все',
    roadTransport: 'Авто',
    railTransport: 'Ж/Д',
    portService: 'Порт',
    specialLogistics: 'Спец',
    otherService: 'Другое',
    noServices: 'Нет услуг',
    backToList: 'Назад к списку',
    serviceNotFound: 'Услуга не найдена',
    serviceDetail: 'Детали услуги',
    serviceFeatures: 'Особенности услуги',
    serviceProcess: 'Процесс услуги',
    importExportPolicy: 'Таможенное регулирование',
    requiredDocuments: 'Требуемые документы',
    relatedDocuments: 'Документы',
    clickToDownload: 'Нажмите для просмотра',
    inquiryNow: 'Запросить',
    quickInquiry: 'Быстрый запрос',
    inquiryDesc: 'Заполните форму и получите оптимальное решение',
    contactName: 'Контактное лицо',
    contactNamePlaceholder: 'Введите имя',
    contactPhone: 'Телефон',
    contactPhonePlaceholder: 'Введите номер телефона',
    contactEmail: 'Email',
    contactEmailPlaceholder: 'Введите email (опционально)',
    originCity: 'Откуда',
    originCityPlaceholder: 'Введите город в Китае',
    destinationCity: 'Куда',
    destinationCityPlaceholder: 'Введите город в России',
    customsCity: 'Таможня',
    customsCityPlaceholder: 'Введите город оформления',
    notes: 'Примечания',
    notesPlaceholder: 'Опишите тип груза, вес, объем...',
    submit: 'Отправить запрос',
    submitting: 'Отправка...',
    submitSuccess: 'Запрос успешно отправлен!',
    submitSuccessDesc: 'Мы свяжемся с вами в течение 24 часов.',
    submitError: 'Ошибка отправки',
  },

  // Страница проектов
  cases: {
    title: 'Проекты',
    subtitle: 'Успешные логистические проекты Китай-Россия',
    noCases: 'Проекты отсутствуют',
    noCasesDesc: 'Контент в разработке',
    viewImages: 'Все изображения',
    images: '',
  },

  // Страница FAQ
  faqs: {
    title: 'Частые вопросы',
    subtitle: 'Ответы на популярные вопросы о наших услугах',
    searchPlaceholder: 'Поиск вопросов...',
    all: 'Все',
    noResults: 'Вопросы не найдены',
    notFound: 'Не нашли свой вопрос?',
    contactUs: 'Свяжитесь с нами',
    categories: {
      transport: 'Перевозки',
      customs: 'Таможня',
      cost: 'Стоимость',
      cooperation: 'Сотрудничество',
      other: 'Другое',
    },
  },

  // Личный кабинет
  user: {
    orders: 'Мои заказы',
    ordersDesc: 'Просмотр и управление заказами',
    newInquiry: 'Новый запрос',
    login: 'Вход',
    register: 'Регистрация',
    loginTitle: 'Вход в личный кабинет',
    registerTitle: 'Регистрация',
    phone: 'Телефон',
    phonePlaceholder: 'Введите номер телефона',
    password: 'Пароль',
    passwordPlaceholder: 'Введите пароль',
    confirmPassword: 'Подтверждение пароля',
    confirmPasswordPlaceholder: 'Повторите пароль',
    name: 'Имя',
    namePlaceholder: 'Введите ваше имя',
    email: 'Email',
    emailPlaceholder: 'Введите email (опционально)',
    company: 'Компания',
    companyPlaceholder: 'Название компании (опционально)',
    noAccount: 'Нет аккаунта?',
    hasAccount: 'Уже есть аккаунт?',
    goLogin: 'Войти',
    goRegister: 'Зарегистрироваться',
    // Боковая панель
    backHome: 'На главную',
    logistics: 'Логистика',
    services: 'Услуги',
    orderManagement: 'Управление заказами',
    personalSettings: 'Настройки',
    editProfile: 'Редактировать профиль',
    changePassword: 'Изменить пароль',
    changeEmail: 'Изменить email',
    // Страницы настроек
    settings: {
      editProfileTitle: 'Редактировать профиль',
      editProfileDesc: 'Обновите вашу информацию',
      changePasswordTitle: 'Изменить пароль',
      changePasswordDesc: 'Регулярная смена пароля повышает безопасность',
      changeEmailTitle: 'Изменить email',
      changeEmailDesc: 'Привяжите или измените email',
      // Поля формы
      name: 'Имя',
      phone: 'Телефон',
      company: 'Компания',
      currentEmail: 'Текущий email',
      noEmail: 'Email не привязан',
      goToChangeEmail: 'Изменить email',
      goToChangeEmailDesc: 'Для изменения email перейдите на страницу',
      page: '',
      // Пароль
      currentPassword: 'Текущий пароль',
      newPassword: 'Новый пароль',
      confirmNewPassword: 'Подтвердите пароль',
      passwordPlaceholder: 'Введите текущий пароль',
      newPasswordPlaceholder: 'Минимум 6 символов',
      confirmPasswordPlaceholder: 'Повторите новый пароль',
      loginPassword: 'Пароль',
      // Email
      verifyPassword: 'Проверка пароля',
      verifyPasswordDesc: 'Введите пароль для продолжения',
      securityVerify: 'Проверка безопасности',
      setNewEmail: 'Новый email',
      newEmail: 'Новый email',
      newEmailPlaceholder: 'Введите новый email',
      // Шаги
      step1: 'Проверка пароля',
      step2: 'Установка email',
      // Кнопки
      save: 'Сохранить',
      saving: 'Сохранение...',
      verify: 'Проверить',
      verifying: 'Проверка...',
      // Сообщения
      updateSuccess: 'Профиль обновлен!',
      updateFailed: 'Ошибка обновления',
      passwordSuccess: 'Пароль изменен!',
      passwordFailed: 'Ошибка изменения',
      emailSuccess: 'Email изменен!',
      emailFailed: 'Ошибка изменения',
      passwordMinLength: 'Минимум 6 символов',
      passwordMismatch: 'Пароли не совпадают',
      networkError: 'Ошибка сети',
      passwordVerifyFailed: 'Неверный пароль',
      // Placeholder
      namePlaceholder: 'Введите ваше имя',
      phonePlaceholder: '11 цифр',
      companyPlaceholder: 'Название компании (опционально)',
    },
  },

  // Статусы заказов
  orderStatus: {
    newInquiry: 'Новый запрос',
    pendingConfirm: 'Ожидает подтверждения',
    loadingPlan: 'Разработка плана загрузки',
    confirmed: 'Подтвержден',
    inTransitCN: 'В пути (Китай)',
    manzhouliStorage: 'Склад в Маньчжурии',
    customsUnfinished: 'На таможне',
    inTransitRU: 'В пути (Россия)',
    delivered: 'Доставлен',
  },

  // Детали заказа
  order: {
    orderNumber: 'Номер заказа',
    status: 'Статус',
    contact: 'Контакт',
    phone: 'Телефон',
    email: 'Email',
    origin: 'Откуда',
    destination: 'Куда',
    customs: 'Таможня',
    notes: 'Примечания',
    createdAt: 'Создан',
    updatedAt: 'Обновлен',
    confirmOrder: 'Подтвердить заказ',
    confirmSuccess: 'Заказ подтвержден',
    sendMessage: 'Отправить',
    messagePlaceholder: 'Введите сообщение...',
    noMessages: 'Нет сообщений',
    uploading: 'Загрузка...',
    attachImage: 'Загрузить фото',
    attachFile: 'Загрузить файл',
    // Новые поля
    detail: 'Детали',
    collapse: 'Свернуть',
    contactInfo: 'Контактная информация',
    transportInfo: 'Информация о перевозке',
    timeInfo: 'Информация о времени',
    originCity: 'Откуда',
    destCity: 'Куда',
    customsCity: 'Таможня',
    createTime: 'Создан',
    updateTime: 'Обновлен',
    notesInfo: 'Примечания',
    transportConfirmed: 'План перевозки отправлен',
    transportConfirmDesc: 'Подтвердите план перевозки',
    transportConfirm: 'Подтвердить перевозку',
    confirming: 'Подтверждение...',
    orderChat: 'Чат по заказу',
    orderChatDesc: 'Связь с менеджером',
    totalOrders: 'заказов',
    newMessages: 'новых',
    noOrders: 'Нет заказов',
    noOrdersDesc: 'У вас пока нет заказов',
    confirmDialog: 'Подтвердить план перевозки? После подтверждения заказ перейдет в исполнение.',
    confirmFailed: 'Ошибка подтверждения, попробуйте позже',
    orderNotFound: 'Заказ не найден',
    loadFailed: 'Ошибка загрузки заказа',
    checkOrderNumber: 'Проверьте номер заказа',
    backToList: 'Назад к заказам',
    orderDetail: 'Детали заказа',
    route: 'Маршрут',
    china: 'Китай',
    russia: 'Россия',
    planSent: 'План перевозки отправлен',
    planSentDesc: 'Подтвердите для начала выполнения',
    confirmPlanMsg: 'Подтвердить план перевозки? После подтверждения заказ перейдет в исполнение.',
    confirmTransport: 'Подтвердить план',
  },

  // Админ-панель
  admin: {
    dashboard: 'Панель',
    orders: 'Заказы',
    customers: 'Клиенты',
    services: 'Услуги',
    cases: 'Проекты',
    faqs: 'FAQ',
    backToHome: 'На сайт',
    logout: 'Выход',
    admin: 'Администратор',
    superAdmin: 'Суперадмин',
    loginTitle: 'Вход для администратора',
    username: 'Имя пользователя',
    usernamePlaceholder: 'Введите имя пользователя',
    passwordPlaceholder: 'Введите пароль',
  },
};
